//
//  SubForm06ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/07/26.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm06ViewController.h"

@interface SubForm06ViewController ()

@end

@implementation SubForm06ViewController

@synthesize objLib = mObjLib;
@synthesize sclView = mSclView;
@synthesize strPrtName = mStrPrtName;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

-(void) viewDidLayoutSubviews
{
    int nmsWidth    = 0;
    int nmsHeight    = btnBack.frame.origin.y + btnBack.frame.size.height + 200;
    
    [mSclView setContentSize: CGSizeMake(nmsWidth, nmsHeight)];
    [mSclView flashScrollIndicators];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    [self btnViewSetting:btnLogCtlType];
    [self btnViewSetting:btnLogupdate];
    [self btnViewSetting:btnLogdelete];
    [self btnViewSetting:btnLogSetProperty];
    [self btnViewSetting:btnBack];
    
    txtViewLogArea.returnKeyType = UIReturnKeyDone;
    txtViewLogArea.font = [UIFont fontWithName:@"Courier" size:14];
    //txtViewLogArea.textColor = [UIColor whiteColor];
    
    txtViewLogArea.delegate = self;
    txtLogtype.delegate = self;
    txtLogSize.delegate = self;
    
    nmsLogType = LOG_CURRENT;
    
    
    // ツールバーの作成
    UIToolbar *toolBar = [[UIToolbar alloc] initWithFrame:CGRectMake(0, 0, 320, 44)];
    toolBar.barStyle = UIBarStyleBlackOpaque; // スタイルを設定
    [toolBar sizeToFit];
    
    // フレキシブルスペースの作成（Doneボタンを右端に配置したいため）
    UIBarButtonItem *spacer = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:self action:nil];
    
    // Doneボタンの作成
    UIBarButtonItem* done = [[UIBarButtonItem alloc]
                                   initWithTitle:@"close"
                                   style:UIBarButtonItemStyleBordered
                                   target:self
                                   action:@selector(closeKeyboard:)];
    
    // ボタンをToolbarに設定
    NSArray *items = [NSArray arrayWithObjects:spacer, done, nil];
    [toolBar setItems:items animated:YES];
    
    // ToolbarをUITextFieldのinputAccessoryViewに設定
    txtViewLogArea.inputAccessoryView = toolBar;
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

-(void)closeKeyboard:(id)sender{
    [txtViewLogArea resignFirstResponder];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

- (IBAction)pushBtnLogUpdate:(UIButton *)sender
{
    int nmsRet = 0;
    NSMutableString* strLog = [NSMutableString string];

    // comment:NPI NLogGetString
    nmsRet = [mObjLib NLogGetString : nmsLogType : strLog];

    txtViewLogArea.text = strLog;

    [self setReturnCode:nmsRet];
    
      // comment:NPI When 'NLogGetLines' method used.
//    NSMutableArray* arrLine = [NSMutableArray array];
//    nmsRet = [mObjLib NLogGetLines : nmsLogType : arrLine];
//    
//    NSLog(@"NLogGetLines ret:%d line count:%d", nmsRet, [arrLine count]);
    
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)pushBtnLogfileDelete:(UIButton *)sender
{
    // comment:NPI NLogDelete
    int nmsRet = [mObjLib NLogDelete : nmsLogType];
    
    if(nmsRet == N_SUCCESS)
    {
        txtViewLogArea.text = @"";
    }
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnLogtypeChange:(UIButton *)sender
{
    NSString* strText = btnLogCtlType.titleLabel.text;
    
    if([strText isEqualToString:@"current"])
    {
        [btnLogCtlType setTitle:@"backup" forState:UIControlStateNormal];
        nmsLogType = LOG_BACKUP;
    }
    else if([strText isEqualToString:@"backup"])
    {
        [btnLogCtlType setTitle:@"both" forState:UIControlStateNormal];
        nmsLogType = LOG_BOTH;
    }
    else if([strText isEqualToString:@"both"])
    {
        [btnLogCtlType setTitle:@"current" forState:UIControlStateNormal];
        nmsLogType = LOG_CURRENT;
    }
}

- (IBAction)pushBtnLogSetProperty:(UIButton *)sender
{
    // comment:NPI NLogSetProperty
    int nmsRet = [mObjLib NLogSetProperty:[txtLogtype text] :[[txtLogSize text] intValue]];
    
    [self setReturnCode:nmsRet];
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil) {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}


@end




